App.Data.NationalityPresets = {};

App.Data.NationalityPresets.Vanilla = new Map([
	["Vanilla Global", {
		Afghan: 2,
		Albanian: 1,
		Algerian: 3,
		American: 6,
		Andorran: 1,
		Angolan: 1,
		Antiguan: 1,
		Argentinian: 4,
		Armenian: 2,
		Aruban: 1,
		Australian: 3,
		Austrian: 2,
		Azerbaijani: 1,
		Bahamian: 1,
		Bahraini: 1,
		Bangladeshi: 4,
		Barbadian: 1,
		Belarusian: 1,
		Belgian: 2,
		Belizean: 1,
		Beninese: 1,
		Bermudian: 1,
		Bhutanese: 1,
		"Bissau-Guinean": 1,
		Bolivian: 2,
		Bosnian: 1,
		Brazilian: 4,
		British: 3,
		Bruneian: 1,
		Bulgarian: 2,
		Burkinabé: 1,
		Burmese: 2,
		Burundian: 1,
		Cambodian: 1,
		Cameroonian: 1,
		Canadian: 2,
		"Cape Verdean": 1,
		Catalan: 1,
		"Central African": 1,
		Chadian: 1,
		Chilean: 2,
		Chinese: 15,
		Colombian: 3,
		Comorian: 1,
		Congolese: 1,
		"a Cook Islander": 1,
		"Costa Rican": 1,
		Croatian: 1,
		Cuban: 2,
		Curaçaoan: 1,
		Cypriot: 1,
		Czech: 2,
		Danish: 2,
		Djiboutian: 1,
		Dominican: 2,
		Dominiquais: 1,
		Dutch: 2,
		"East Timorese": 1,
		Ecuadorian: 1,
		Egyptian: 3,
		Emirati: 2,
		Equatoguinean: 1,
		Eritrean: 1,
		Estonian: 2,
		Ethiopian: 3,
		Fijian: 1,
		Filipina: 3,
		Finnish: 2,
		French: 3,
		"French Guianan": 1,
		"French Polynesian": 1,
		Gabonese: 1,
		Gambian: 1,
		Georgian: 1,
		German: 3,
		Ghanan: 2,
		Greek: 2,
		Greenlandic: 1,
		Grenadian: 1,
		Guamanian: 1,
		Guatemalan: 1,
		Guinean: 1,
		Guyanese: 1,
		Haitian: 2,
		Honduran: 1,
		Hungarian: 2,
		"I-Kiribati": 1,
		Icelandic: 2,
		Indian: 11,
		Indonesian: 5,
		Iranian: 3,
		Iraqi: 2,
		Irish: 2,
		Israeli: 2,
		Italian: 3,
		Ivorian: 1,
		Jamaican: 2,
		Japanese: 3,
		Jordanian: 2,
		Kazakh: 2,
		Kenyan: 3,
		Kittitian: 1,
		Korean: 2,
		Kosovan: 1,
		Kurdish: 1,
		Kuwaiti: 1,
		Kyrgyz: 1,
		Laotian: 1,
		Latvian: 1,
		Lebanese: 2,
		Liberian: 1,
		Libyan: 2,
		"a Liechtensteiner": 1,
		Lithuanian: 2,
		Luxembourgian: 1,
		Macedonian: 1,
		Malagasy: 1,
		Malawian: 1,
		Malaysian: 3,
		Maldivian: 1,
		Malian: 2,
		Maltese: 1,
		Marshallese: 1,
		Mauritanian: 1,
		Mauritian: 1,
		Mexican: 4,
		Micronesian: 1,
		Moldovan: 1,
		Monégasque: 1,
		Mongolian: 1,
		Montenegrin: 1,
		Moroccan: 2,
		Mosotho: 1,
		Motswana: 1,
		Mozambican: 1,
		Namibian: 1,
		Nauruan: 1,
		Nepalese: 2,
		"New Caledonian": 1,
		"a New Zealander": 2,
		"Ni-Vanuatu": 1,
		Nicaraguan: 2,
		Nigerian: 4,
		Nigerien: 2,
		Niuean: 1,
		Norwegian: 2,
		Omani: 2,
		Pakistani: 3,
		Palauan: 1,
		Palestinian: 1,
		Panamanian: 1,
		"Papua New Guinean": 1,
		Paraguayan: 1,
		Peruvian: 2,
		Polish: 3,
		Portuguese: 2,
		"Puerto Rican": 1,
		Qatari: 1,
		Romanian: 2,
		Russian: 4,
		Rwandan: 1,
		Sahrawi: 1,
		"Saint Lucian": 1,
		Salvadoran: 2,
		Sammarinese: 1,
		Samoan: 1,
		"São Toméan": 1,
		Saudi: 2,
		Scottish: 1,
		Senegalese: 1,
		Serbian: 2,
		Seychellois: 1,
		"Sierra Leonean": 1,
		Singaporean: 1,
		Slovak: 2,
		Slovene: 1,
		"a Solomon Islander": 1,
		Somali: 1,
		"South African": 4,
		"South Sudanese": 1,
		Spanish: 3,
		"Sri Lankan": 1,
		Sudanese: 3,
		Surinamese: 1,
		Swazi: 1,
		Swedish: 2,
		Swiss: 2,
		Syrian: 1,
		Taiwanese: 1,
		Tajik: 1,
		Tanzanian: 2,
		Thai: 3,
		Tibetan: 1,
		Togolese: 1,
		Tongan: 1,
		Trinidadian: 1,
		Tunisian: 2,
		Turkish: 3,
		Turkmen: 1,
		Tuvaluan: 1,
		Ugandan: 2,
		Ukrainian: 3,
		Uruguayan: 2,
		Uzbek: 2,
		Vatican: 1,
		Venezuelan: 3,
		Vietnamese: 3,
		Vincentian: 1,
		Yemeni: 2,
		Zairian: 3,
		Zambian: 1,
		Zimbabwean: 2
	}],
	["Vanilla North America", {
		American: 6,
		Antiguan: 1,
		Aruban: 1,
		Bahamian: 1,
		Barbadian: 1,
		Belizean: 1,
		Bermudian: 1,
		Canadian: 2,
		"Costa Rican": 1,
		Cuban: 2,
		Curaçaoan: 1,
		Dominican: 2,
		Dominiquais: 1,
		Greenlandic: 1,
		Grenadian: 1,
		Guatemalan: 1,
		Haitian: 2,
		Honduran: 1,
		Jamaican: 2,
		Kittitian: 1,
		Mexican: 4,
		Nicaraguan: 2,
		Panamanian: 1,
		"Puerto Rican": 1,
		"Saint Lucian": 1,
		Salvadoran: 2,
		Trinidadian: 1,
		Vincentian: 1
	}],
	["Vanilla South America", {
		Argentinian: 4,
		Bolivian: 2,
		Brazilian: 4,
		Chilean: 2,
		Colombian: 3,
		Ecuadorian: 1,
		"French Guianan": 1,
		Guyanese: 1,
		Paraguayan: 1,
		Peruvian: 2,
		Surinamese: 1,
		Uruguayan: 2,
		Venezuelan: 3
	}],
	["Vanilla Middle East", {
		Afghan: 2,
		Armenian: 2,
		Azerbaijani: 1,
		Bahraini: 1,
		Cypriot: 1,
		Egyptian: 3,
		Emirati: 2,
		Georgian: 1,
		Iranian: 3,
		Iraqi: 2,
		Israeli: 2,
		Jordanian: 2,
		Kurdish: 1,
		Kuwaiti: 1,
		Lebanese: 2,
		Omani: 2,
		Palestinian: 1,
		Qatari: 1,
		Saudi: 2,
		Syrian: 1,
		Turkish: 3,
		Yemeni: 2
	}],
	["Vanilla Africa", {
		Algerian: 3,
		Angolan: 1,
		Beninese: 1,
		"Bissau-Guinean": 1,
		Burkinabé: 1,
		Burundian: 1,
		Cameroonian: 1,
		"Cape Verdean": 1,
		"Central African": 1,
		Chadian: 1,
		Comorian: 1,
		Congolese: 1,
		Djiboutian: 1,
		Equatoguinean: 1,
		Eritrean: 1,
		Ethiopian: 3,
		Gabonese: 1,
		Gambian: 1,
		Ghanan: 2,
		Guinean: 1,
		Ivorian: 1,
		Kenyan: 3,
		Liberian: 1,
		Libyan: 2,
		Malagasy: 1,
		Malawian: 1,
		Malian: 2,
		Mauritanian: 1,
		Mauritian: 1,
		Moroccan: 2,
		Mosotho: 1,
		Motswana: 1,
		Mozambican: 1,
		Namibian: 1,
		Nigerian: 4,
		Nigerien: 2,
		Rwandan: 1,
		Sahrawi: 1,
		"São Toméan": 1,
		Senegalese: 1,
		Seychellois: 1,
		"Sierra Leonean": 1,
		Somali: 1,
		"South African": 4,
		"South Sudanese": 1,
		Sudanese: 3,
		Swazi: 1,
		Tanzanian: 2,
		Togolese: 1,
		Tunisian: 2,
		Ugandan: 2,
		Zairian: 3,
		Zambian: 1,
		Zimbabwean: 2
	}],
	["Vanilla Asia", {
		Bangladeshi: 4,
		Bhutanese: 1,
		Bruneian: 1,
		Burmese: 2,
		Cambodian: 1,
		Chinese: 15,
		"East Timorese": 1,
		Filipina: 3,
		Indian: 11,
		Indonesian: 5,
		Japanese: 3,
		Kazakh: 2,
		Korean: 2,
		Kyrgyz: 1,
		Laotian: 1,
		Malaysian: 3,
		Maldivian: 1,
		Mongolian: 1,
		Nepalese: 2,
		Pakistani: 3,
		Singaporean: 1,
		"Sri Lankan": 1,
		Taiwanese: 1,
		Tajik: 1,
		Thai: 3,
		Tibetan: 1,
		Turkmen: 1,
		Uzbek: 2,
		Vietnamese: 3
	}],
	["Vanilla Europe", {
		Albanian: 1,
		Andorran: 1,
		Austrian: 2,
		Belarusian: 1,
		Belgian: 2,
		Bosnian: 1,
		British: 3,
		Bulgarian: 2,
		Catalan: 1,
		Croatian: 1,
		Czech: 2,
		Danish: 2,
		Dutch: 2,
		Estonian: 2,
		Finnish: 2,
		French: 3,
		German: 3,
		Greek: 2,
		Hungarian: 2,
		Icelandic: 2,
		Irish: 2,
		Italian: 3,
		Kosovan: 1,
		Latvian: 1,
		"a Liechtensteiner": 1,
		Lithuanian: 2,
		Luxembourgian: 1,
		Macedonian: 1,
		Maltese: 1,
		Moldovan: 1,
		Monégasque: 1,
		Montenegrin: 1,
		Norwegian: 2,
		Polish: 3,
		Portuguese: 2,
		Romanian: 2,
		Russian: 4,
		Sammarinese: 1,
		Scottish: 1,
		Serbian: 2,
		Slovak: 2,
		Slovene: 1,
		Spanish: 3,
		Swedish: 2,
		Swiss: 2,
		Ukrainian: 3,
		Vatican: 1
	}],
	["Vanilla Australia", {
		Australian: 3,
		"a Cook Islander": 1,
		Fijian: 1,
		"French Polynesian": 1,
		Guamanian: 1,
		"I-Kiribati": 1,
		Marshallese: 1,
		Micronesian: 1,
		Nauruan: 1,
		"New Caledonian": 1,
		"a New Zealander": 2,
		"Ni-Vanuatu": 1,
		Niuean: 1,
		Palauan: 1,
		"Papua New Guinean": 1,
		Samoan: 1,
		"a Solomon Islander": 1,
		Tongan: 1,
		Tuvaluan: 1
	}],
]);

App.Data.NationalityPresets.Mod = new Map([
	["Realism North America", {
		American: 36503,
		Antiguan: 11,
		Aruban: 10,
		Bahamian: 45,
		Barbadian: 28,
		Belizean: 50,
		Bermudian: 5,
		Canadian: 4188,
		"Costa Rican": 555,
		Cuban: 1141,
		Curaçaoan: 17,
		Dominican: 1249,
		Dominiquais: 7,
		Greenlandic: 5,
		Grenadian: 11,
		Guatemalan: 2277,
		Haitian: 1303,
		Honduran: 1177,
		Jamaican: 290,
		Kittitian: 6,
		Mexican: 15306,
		Nicaraguan: 731,
		Panamanian: 515,
		"Puerto Rican": 354,
		"Saint Lucian": 18,
		Salvadoran: 688,
		Trinidadian: 136,
		Vincentian: 11
	}],
	["Realism South America", {
		Argentinian: 5102,
		Bolivian: 1392,
		Brazilian: 22920,
		Chilean: 2005,
		Colombian: 5105,
		Ecuadorian: 2055,
		"French Guianan": 41,
		Guyanese: 83,
		Paraguayan: 817,
		Peruvian: 3829,
		Surinamese: 63,
		Uruguayan: 362,
		Venezuelan: 3826
	}],
	["Realism Middle East", {
		Afghan: 5090,
		Armenian: 286,
		Azerbaijani: 1086,
		Bahraini: 212,
		Cypriot: 131,
		Egyptian: 12826,
		Emirati: 1164,
		Georgian: 366,
		Iranian: 9047,
		Iraqi: 5982,
		Israeli: 1062,
		Jordanian: 1184,
		Kurdish: 7258,
		Kuwaiti: 511,
		Lebanese: 533,
		Omani: 612,
		Palestinian: 746,
		Qatari: 340,
		Saudi: 4131,
		Syrian: 2888,
		Turkish: 9091,
		Yemeni: 3996
	}],
	["Realism Africa", {
		Algerian: 5107,
		Angolan: 5166,
		Beninese: 1756,
		"Bissau-Guinean": 275,
		Burkinabé: 3105,
		Burundian: 1797,
		Cameroonian: 3688,
		"Cape Verdean": 66,
		"Central African": 679,
		Chadian: 2431,
		Comorian: 116,
		Congolese: 827,
		Djiboutian: 118,
		Equatoguinean: 210,
		Eritrean: 742,
		Ethiopian: 15303,
		Gabonese: 282,
		Gambian: 338,
		Ghanan: 4071,
		Guinean: 1978,
		Ivorian: 3741,
		Kenyan: 7408,
		Liberian: 727,
		Libyan: 760,
		Malagasy: 3989,
		Malawian: 3010,
		Malian: 3098,
		Mauritanian: 676,
		Mauritian: 128,
		Moroccan: 4240,
		Mosotho: 275,
		Motswana: 297,
		Mozambican: 4824,
		Namibian: 352,
		Nigerian: 29732,
		Nigerien: 4187,
		Rwandan: 1754,
		Sahrawi: 80,
		"São Toméan": 29,
		Senegalese: 2486,
		Seychellois: 9,
		"Sierra Leonean": 1056,
		Somali: 2469,
		"South African": 6688,
		"South Sudanese": 1918,
		Sudanese: 6099,
		Swazi: 177,
		Tanzanian: 9586,
		Togolese: 1166,
		Tunisian: 1316,
		Ugandan: 7338,
		Zairian: 13815,
		Zambian: 2844,
		Zimbabwean: 2355
	}],
	["Realism Asia", {
		Bangladeshi: 19160,
		Bhutanese: 94,
		Bruneian: 50,
		Burmese: 6043,
		Cambodian: 1972,
		Chinese: 143350,
		"East Timorese": 187,
		Filipina: 13266,
		Indian: 156457,
		Indonesian: 30475,
		Japanese: 11849,
		Kazakh: 2095,
		Korean: 7977,
		Kyrgyz: 730,
		Laotian: 841,
		Malaysian: 3838,
		Maldivian: 52,
		Mongolian: 369,
		Nepalese: 3456,
		Pakistani: 26109,
		Singaporean: 647,
		"Sri Lankan": 2149,
		Taiwanese: 2410,
		Tajik: 1202,
		Thai: 6919,
		Tibetan: 435,
		Turkmen: 707,
		Uzbek: 3805,
		Vietnamese: 3255
	}],
	/* I need reweighting and possibly country additions */
	["Realism Europe", {
		Albanian: 289,
		Andorran: 7,
		Austrian: 897,
		Belarusian: 899,
		Belgian: 1215,
		Bosnian: 333,
		British: 7189,
		Bulgarian: 615,
		Catalan: 767,
		Croatian: 379,
		Czech: 1039,
		Danish: 611,
		Dutch: 1769,
		Estonian: 122,
		Finnish: 578,
		French: 6886,
		German: 8173,
		Greek: 1062,
		Hungarian: 900,
		Icelandic: 37,
		Irish: 537,
		Italian: 5753,
		Kosovan: 193,
		Latvian: 168,
		"a Liechtensteiner": 4,
		Lithuanian: 263,
		Luxembourgian: 70,
		Macedonian: 205,
		Maltese: 43,
		Moldovan: 372,
		Monégasque: 4,
		Montenegrin: 61,
		Norwegian: 619,
		Polish: 3569,
		Portuguese: 969,
		Romanian: 1797,
		Russian: 13807,
		Sammarinese: 3,
		Scottish: 575,
		Serbian: 814,
		Slovak: 530,
		Slovene: 203,
		Spanish: 4586,
		Swedish: 1094,
		Swiss: 941,
		Ukrainian: 3989,
		Vatican: 1
	}],
	["Realism Australia", {
		Australian: 2952,
		"a Cook Islander": 1,
		Fijian: 98,
		"French Polynesian": 31,
		Guamanian: 18,
		"I-Kiribati": 15,
		Marshallese: 5,
		Micronesian: 12,
		Nauruan: 1,
		"New Caledonian": 33,
		"a New Zealander": 536,
		"Ni-Vanuatu": 38,
		Niuean: 1,
		Palauan: 2,
		"Papua New Guinean": 1136,
		Samoan: 22,
		"a Solomon Islander": 83,
		Tongan: 12,
		Tuvaluan: 1
	}],
	["East Asia", {Chinese: 21, Japanese: 2, Korean: 1}],
	["USA", {American: 8, Canadian: 1, Mexican: 3}],
	["Brazil", {
		Argentinian: 4,
		Bolivian: 2,
		Brazilian: 30,
		Chilean: 2,
		Colombian: 3,
		Ecuadorian: 1,
		"French Guianan": 1,
		Guyanese: 1,
		Paraguayan: 1,
		Peruvian: 2,
		Surinamese: 1,
		Uruguayan: 2,
		Venezuelan: 2
	}],
	["Mediterranean", {
		Albanian: 29,
		Algerian: 404,
		Andorran: 1,
		Bosnian: 35,
		British: 1,
		Bulgarian: 71,
		Catalan: 75,
		Croatian: 42,
		Cypriot: 12,
		Egyptian: 948,
		French: 671,
		Georgian: 49,
		Greek: 108,
		Israeli: 89,
		Italian: 605,
		Lebanese: 60,
		Libyan: 63,
		Maltese: 5,
		Monégasque: 1,
		Montenegrin: 7,
		Moroccan: 358,
		Palestinian: 18,
		Portuguese: 102,
		Romanian: 132,
		Russian: 40,
		Sammarinese: 1,
		Slovene: 21,
		Spanish: 466,
		Syrian: 171,
		Tunisian: 113,
		Turkish: 808,
		Ukrainian: 105,
		Vatican: 1,
	}],

	/* I need reweighting */
	["Realism Global", {
		Afghan: 5090,
		Albanian: 289,
		Algerian: 5107,
		American: 36503,
		Andorran: 7,
		Angolan: 5166,
		Antiguan: 11,
		Argentinian: 5102,
		Armenian: 286,
		Aruban: 10,
		Australian: 2952,
		Austrian: 897,
		Azerbaijani: 1086,
		Bahamian: 45,
		Bahraini: 212,
		Bangladeshi: 19160,
		Barbadian: 28,
		Belarusian: 899,
		Belgian: 1215,
		Belizean: 50,
		Beninese: 1756,
		Bermudian: 5,
		Bhutanese: 94,
		"Bissau-Guinean": 275,
		Bolivian: 1392,
		Bosnian: 333,
		Brazilian: 22920,
		British: 7189,
		Bruneian: 50,
		Bulgarian: 615,
		Burkinabé: 3105,
		Burmese: 6043,
		Burundian: 1797,
		Cambodian: 1972,
		Cameroonian: 3688,
		Canadian: 4188,
		"Cape Verdean": 66,
		Catalan: 767,
		"Central African": 679,
		Chadian: 2431,
		Chilean: 2005,
		Chinese: 143350,
		Colombian: 5405,
		Comorian: 116,
		Congolese: 827,
		"a Cook Islander": 1,
		"Costa Rican": 555,
		Croatian: 379,
		Cuban: 1141,
		Curaçaoan: 17,
		Cypriot: 131,
		Czech: 1039,
		Danish: 611,
		Djiboutian: 118,
		Dominican: 1249,
		Dominiquais: 7,
		Dutch: 1769,
		"East Timorese": 187,
		Ecuadorian: 2055,
		Egyptian: 12826,
		Emirati: 1164,
		Equatoguinean: 210,
		Eritrean: 742,
		Estonian: 122,
		Ethiopian: 15303,
		Fijian: 98,
		Filipina: 13266,
		Finnish: 578,
		French: 6886,
		"French Guianan": 41,
		"French Polynesian": 31,
		Gabonese: 282,
		Gambian: 338,
		Georgian: 366,
		German: 8173,
		Ghanan: 4071,
		Greek: 1062,
		Greenlandic: 5,
		Grenadian: 11,
		Guamanian: 18,
		Guatemalan: 2277,
		Guinean: 1978,
		Guyanese: 83,
		Haitian: 1303,
		Honduran: 1177,
		Hungarian: 900,
		"I-Kiribati": 15,
		Icelandic: 37,
		Indian: 156457,
		Indonesian: 30475,
		Iranian: 9047,
		Iraqi: 5982,
		Irish: 537,
		Israeli: 1062,
		Italian: 5753,
		Ivorian: 3741,
		Jamaican: 290,
		Japanese: 11849,
		Jordanian: 1184,
		Kazakh: 2095,
		Kenyan: 7408,
		Kittitian: 6,
		Korean: 7977,
		Kosovan: 193,
		Kurdish: 7258,
		Kuwaiti: 511,
		Kyrgyz: 730,
		Laotian: 841,
		Latvian: 168,
		Lebanese: 533,
		Liberian: 727,
		Libyan: 760,
		"a Liechtensteiner": 4,
		Lithuanian: 263,
		Luxembourgian: 70,
		Macedonian: 205,
		Malagasy: 3989,
		Malawian: 3010,
		Malaysian: 3838,
		Maldivian: 52,
		Malian: 3098,
		Maltese: 43,
		Marshallese: 5,
		Mauritanian: 676,
		Mauritian: 128,
		Mexican: 15306,
		Micronesian: 12,
		Moldovan: 372,
		Monégasque: 4,
		Mongolian: 369,
		Montenegrin: 61,
		Moroccan: 4240,
		Mosotho: 275,
		Motswana: 297,
		Mozambican: 4824,
		Namibian: 352,
		Nauruan: 1,
		Nepalese: 3456,
		"New Caledonian": 33,
		"a New Zealander": 536,
		"Ni-Vanuatu": 38,
		Nicaraguan: 731,
		Nigerian: 29732,
		Nigerien: 4187,
		Niuean: 1,
		Norwegian: 619,
		Omani: 612,
		Pakistani: 26109,
		Palauan: 2,
		Palestinian: 746,
		Panamanian: 515,
		"Papua New Guinean": 1136,
		Paraguayan: 817,
		Peruvian: 3829,
		Polish: 3569,
		Portuguese: 969,
		"Puerto Rican": 354,
		Qatari: 340,
		Romanian: 1797,
		Russian: 13807,
		Rwandan: 1754,
		Sahrawi: 80,
		"Saint Lucian": 18,
		Salvadoran: 688,
		Sammarinese: 3,
		Samoan: 22,
		"São Toméan": 29,
		Saudi: 4131,
		Scottish: 575,
		Senegalese: 2486,
		Serbian: 814,
		Seychellois: 9,
		"Sierra Leonean": 1056,
		Singaporean: 647,
		Slovak: 530,
		Slovene: 203,
		"a Solomon Islander": 83,
		Somali: 2469,
		"South African": 6688,
		"South Sudanese": 1918,
		Spanish: 4586,
		"Sri Lankan": 2149,
		Sudanese: 6099,
		Surinamese: 63,
		Swazi: 177,
		Swedish: 1094,
		Swiss: 941,
		Syrian: 2888,
		Taiwanese: 2410,
		Tajik: 1202,
		Tanzanian: 9586,
		Thai: 6919,
		Tibetan: 435,
		Togolese: 1166,
		Tongan: 12,
		Trinidadian: 136,
		Tunisian: 1316,
		Turkish: 9091,
		Turkmen: 707,
		Tuvaluan: 1,
		Ugandan: 7338,
		Ukrainian: 3989,
		Uruguayan: 362,
		Uzbek: 3805,
		Vatican: 1,
		Venezuelan: 3826,
		Vietnamese: 10898,
		Vincentian: 11,
		Yemeni: 3996,
		Zairian: 13815,
		Zambian: 2844,
		Zimbabwean: 2355
	}],

	["Japan/Korea weighted sea trade", {
		Chinese: 2000,
		Korean: 2000,
		Japanese: 2000,
		American: 500,
		Russian: 500,
		Filipina: 500,
		Taiwanese: 500,
		Vietnamese: 500,
		Cambodian: 500,
		Malaysian: 500,
		Indonesian: 500,
		Australian: 200,
		"Papua New Guinean": 200,
		"a New Zealander": 200,
		Canadian: 200,
		Mexican: 200,
		Ecuadorian: 200,
		Peruvian: 200,
		Chilean: 200,
		Thai: 200,
		Burmese: 200,
		Bangladeshi: 200,
		Indian: 200,
		"Sri Lankan": 200,
		Iranian: 200,
		Pakistani: 200,
		Omani: 200,
		Yemeni: 200,
		Malagasy: 200,
		Somali: 200,
		"a Solomon Islander": 200,
		"New Caledonian": 200,
		Fijian: 200,
		Mongolian: 200,
		Tibetan: 200,
		Laotian: 200,
		Argentinian: 80,
		Belgian: 80,
		Armenian: 80,
		Austrian: 80,
		Bulgarian: 80,
		British: 80,
		Brazilian: 80,
		Colombian: 80,
		"Costa Rican": 80,
		Croatian: 80,
		Danish: 80,
		Czech: 80,
		Cuban: 80,
		Dutch: 80,
		Egyptian: 80,
		Ethiopian: 80,
		Finnish: 80,
		French: 80,
		Greek: 80,
		German: 80,
		Georgian: 80,
		Hungarian: 80,
		Honduran: 80,
		Iraqi: 80,
		Irish: 80,
		Israeli: 80,
		Italian: 80,
		Kazakh: 80,
		Jordanian: 80,
		Moroccan: 80,
		Nepalese: 80,
		Nicaraguan: 80,
		Norwegian: 80,
		Portuguese: 80,
		Polish: 80,
		Paraguayan: 80,
		Romanian: 80,
		Salvadoran: 80,
		Scottish: 80,
		Serbian: 80,
		Singaporean: 80,
		"South African": 80,
		Swedish: 80,
		Spanish: 80,
		Turkish: 80,
		Tunisian: 80,
		Turkmen: 80,
		Ukrainian: 80,
		Uruguayan: 80,
		Venezuelan: 80,
		Afghan: 12,
		Azerbaijani: 12,
		Bolivian: 12,
		Dominican: 12,
		Emirati: 12,
		Gambian: 12,
		Grenadian: 12,
		Jamaican: 12,
		Latvian: 12,
		Luxembourgian: 12,
		Micronesian: 12,
		Panamanian: 12,
		"Puerto Rican": 12,
		Swiss: 12,
		Zambian: 12,
		Zimbabwean: 12,
		Togolese: 12,
		Syrian: 12,
		Slovene: 12,
		Senegalese: 12,
		Qatari: 12,
		Moldovan: 12,
		Macedonian: 12,
		Lebanese: 12,
		Kosovan: 12,
		Catalan: 12,
		Bosnian: 12,
		Belizean: 12,
		Bahamian: 12,
		Albanian: 12,
		Algerian: 12,
		Bahraini: 12,
		Beninese: 12,
		"Central African": 12,
		Congolese: 12,
		Cypriot: 12,
		Guatemalan: 12,
		Kurdish: 12,
		Liberian: 12,
		Marshallese: 12,
		Mozambican: 12,
		Sudanese: 12,
		Tongan: 12,
		Ugandan: 12,
		Mauritanian: 12,
		Libyan: 12,
		Kuwaiti: 12,
		Icelandic: 12,
		Ghanan: 12,
		Estonian: 12,
		Chadian: 12,
		Bermudian: 12,
		Bhutanese: 12,
		Bruneian: 12,
		Cameroonian: 12,
		Guyanese: 12,
		Kenyan: 12,
		Kyrgyz: 12,
		Montenegrin: 12,
		Nigerian: 12,
		Tanzanian: 12,
		Zairian: 12,
		Uzbek: 12,
		"South Sudanese": 12,
		Saudi: 12,
		Palestinian: 12,
		Nigerien: 12,
		Lithuanian: 12,
		Ivorian: 12,
		Haitian: 12,
		Greenlandic: 12,
		Gabonese: 12,
		Belarusian: 12,
		Angolan: 12,
		"French Polynesian": 12,
		Antiguan: 2,
		Burkinabé: 2,
		"Cape Verdean": 2,
		Malian: 2,
		Mosotho: 2,
		Niuean: 2,
		"Saint Lucian": 2,
		Slovak: 2,
		Vatican: 2,
		Tuvaluan: 2,
		Motswana: 2,
		Maltese: 2,
		Guamanian: 2,
		Equatoguinean: 2,
		Dominiquais: 2,
		Curaçaoan: 2,
		Comorian: 2,
		Burundian: 2,
		Eritrean: 2,
		"I-Kiribati": 2,
		Monégasque: 2,
		"Ni-Vanuatu": 2,
		Sammarinese: 2,
		Vincentian: 2,
		Trinidadian: 2,
		Tajik: 2,
		Surinamese: 2,
		Seychellois: 2,
		Samoan: 2,
		Namibian: 2,
		Malawian: 2,
		Guinean: 2,
		"French Guianan": 2,
		"East Timorese": 2,
		"a Cook Islander": 2,
		Aruban: 2,
		Andorran: 2,
		Barbadian: 2,
		"a Liechtensteiner": 2,
		Mauritian: 2,
		Nauruan: 2,
		Palauan: 2,
		Rwandan: 2,
		"Sierra Leonean": 2,
		"São Toméan": 2,
		Swazi: 2,
		Sahrawi: 2,
		Maldivian: 2,
		Kittitian: 2,
		Djiboutian: 2
	}],

	["Polish-Lithuanian Commonwealth with Silk Road", {
		Polish: 2000,
		Ukrainian: 2000,
		Belarusian: 2000,
		Chinese: 500,
		Japanese: 500,
		Korean: 500,
		Russian: 500,
		German: 500,
		French: 500,
		Italian: 500,
		Turkish: 500,
		Uzbek: 200,
		Kazakh: 200,
		Indian: 200,
		Pakistani: 200,
		Afghan: 200,
		Iranian: 200,
		Iraqi: 200,
		Syrian: 200,
		Egyptian: 200,
		Saudi: 200,
		Austrian: 200,
		British: 200,
		Bulgarian: 200,
		Croatian: 200,
		Czech: 200,
		Danish: 200,
		Dutch: 200,
		Estonian: 200,
		Finnish: 80,
		Greek: 200,
		Hungarian: 200,
		Latvian: 200,
		Lithuanian: 200,
		Macedonian: 80,
		Moldovan: 80,
		Romanian: 200,
		Spanish: 200,
		Swedish: 200,
		Nigerian: 80,
		Ethiopian: 80,
		Congolese: 80,
		Moroccan: 80,
		Algerian: 80,
		Tunisian: 80,
		Libyan: 80,
		Sudanese: 80,
		Bangladeshi: 80,
		Burmese: 80,
		Filipina: 80,
		Indonesian: 80,
		Kyrgyz: 80,
		Malaysian: 80,
		Nepalese: 80,
		Taiwanese: 80,
		Tajik: 80,
		Thai: 80,
		Tibetan: 80,
		Turkmen: 80,
		Vietnamese: 80,
		Australian: 80,
		Albanian: 80,
		Belgian: 80,
		Bosnian: 80,
		Irish: 80,
		Swiss: 80,
		Scottish: 80,
		Norwegian: 80,
		Serbian: 80,
		Slovak: 80,
		Portuguese: 80,
		Slovene: 80,
		Kosovan: 80,
		American: 80,
		Canadian: 80,
		Cuban: 80,
		Mexican: 80,
		Brazilian: 80,
		Colombian: 80,
		Argentinian: 80,
		Peruvian: 80,
		Venezuelan: 80,
		Catalan: 12,
		Georgian: 80,
		Armenian: 80,
		Yemeni: 80,
		Jordanian: 80,
		Emirati: 12,
		Mongolian: 12,
		Bolivian: 12,
		Paraguayan: 12,
		Chilean: 12,
		Uruguayan: 12,
		Ecuadorian: 12,
		Salvadoran: 12,
		Jamaican: 12,
		Dominiquais: 12,
		"Costa Rican": 12,
		Guatemalan: 12,
		Nicaraguan: 12,
		Haitian: 12,
		Dominican: 12,
		Honduran: 12,
		Lebanese: 12,
		Kuwaiti: 12,
		Kurdish: 12,
		Azerbaijani: 12,
		Bahraini: 12,
		Omani: 12,
		Palestinian: 12,
		Israeli: 12,
		Cypriot: 12,
		Qatari: 12,
		Icelandic: 12,
		Montenegrin: 12,
		Luxembourgian: 12,
		"Papua New Guinean": 12,
		Bhutanese: 12,
		Bruneian: 12,
		Laotian: 12,
		Singaporean: 12,
		Maldivian: 12,
		Cambodian: 12,
		"East Timorese": 12,
		Cameroonian: 12,
		Mosotho: 12,
		Ghanan: 12,
		Rwandan: 12,
		Malagasy: 12,
		Somali: 12,
		"South African": 12,
		Malawian: 12,
		Guinean: 12,
		Equatoguinean: 12,
		Angolan: 12,
		Beninese: 12,
		"Central African": 12,
		Eritrean: 12,
		Ivorian: 12,
		Mozambican: 12,
		"South Sudanese": 12,
		Ugandan: 12,
		Zairian: 12,
		Senegalese: 12,
		Namibian: 12,
		Mauritanian: 12,
		Kenyan: 12,
		Chadian: 12,
		Gabonese: 12,
		Liberian: 12,
		Mauritian: 12,
		Swazi: 12,
		Zambian: 12,
		Zimbabwean: 12,
		Tanzanian: 12,
		"Sierra Leonean": 12,
		Nigerien: 12,
		Gambian: 12,
		Burundian: 12,
		Guyanese: 2,
		"French Guianan": 2,
		Surinamese: 12,
		Greenlandic: 12,
		Bahamian: 2,
		Djiboutian: 2,
		Togolese: 2,
		Sahrawi: 2,
		Motswana: 2,
		"Cape Verdean": 2,
		Malian: 2,
		"São Toméan": 2,
		"Bissau-Guinean": 2,
		Burkinabé: 2,
		Comorian: 2,
		Seychellois: 2,
		Marshallese: 2,
		Niuean: 2,
		Tuvaluan: 2,
		Palauan: 2,
		Micronesian: 2,
		"a Cook Islander": 2,
		Fijian: 2,
		Nauruan: 2,
		Samoan: 2,
		"New Caledonian": 2,
		"French Polynesian": 2,
		Guamanian: 2,
		"a New Zealander": 2,
		"a Solomon Islander": 2,
		Tongan: 2,
		"Ni-Vanuatu": 2,
		"I-Kiribati": 2,
		"a Liechtensteiner": 2,
		Monégasque: 2,
		Sammarinese: 2,
		Andorran: 2,
		Maltese: 2,
		Vatican: 2,
		Bermudian: 2,
		"Saint Lucian": 2,
		Kittitian: 2,
		Antiguan: 2,
		Aruban: 2,
		Grenadian: 2,
		Trinidadian: 2,
		Vincentian: 2,
		Panamanian: 2,
		Curaçaoan: 2,
		Barbadian: 2,
		Belizean: 2,
		"Puerto Rican": 2,
		"Sri Lankan": 2
	}],

	["Caribbean and Gulf of Mexico", {
		Mexican: 1100,
		American: 1100,
		Guatemalan: 520,
		Haitian: 520,
		Cuban: 520,
		Dominican: 520,
		Honduran: 520,
		Salvadoran: 520,
		Nicaraguan: 520,
		"Costa Rican": 520,
		Panamanian: 520,
		"Puerto Rican": 520,
		Jamaican: 520,
		Trinidadian: 520,
		Colombian: 520,
		Venezuelan: 520,
		Brazilian: 520,
		Belizean: 200,
		Bahamian: 200,
		Barbadian: 200,
		Guyanese: 200,
		Surinamese: 200,
		"French Guianan": 200,
		Ecuadorian: 200,
		Peruvian: 200,
		Chilean: 200,
		Argentinian: 200,
		Uruguayan: 200,
		Paraguayan: 200,
		Bolivian: 200,
		Portuguese: 200,
		Spanish: 200,
		French: 200,
		British: 200,
		Irish: 200,
		Scottish: 200,
		Dutch: 200,
		Japanese: 200,
		Filipina: 200,
		Indonesian: 200,
		Algerian: 80,
		"Saint Lucian": 80,
		Grenadian: 80,
		Vincentian: 80,
		Antiguan: 80,
		Dominiquais: 80,
		Australian: 80,
		Bangladeshi: 80,
		Belgian: 80,
		Bermudian: 80,
		Curaçaoan: 80,
		Greenlandic: 80,
		German: 80,
		Indian: 80,
		Italian: 80,
		Korean: 80,
		Malaysian: 80,
		Nigerian: 80,
		Norwegian: 80,
		"Papua New Guinean": 80,
		Russian: 80,
		Swedish: 80,
		Turkish: 80,
		Taiwanese: 80,
		Chinese: 80,
		Canadian: 80,
		Iranian: 80,
		Kittitian: 80,
		Ivorian: 80,
		Moroccan: 80,
		Nigerien: 80,
		"French Polynesian": 80,
		Danish: 80,
		Bruneian: 80,
		Aruban: 80,
		Icelandic: 80,
		Vietnamese: 80,
		Samoan: 80,
		Congolese: 80,
		"a Solomon Islander": 80,
		"a New Zealander": 80,
		Catalan: 80,
		Tunisian: 80,
		"Sri Lankan": 80,
		"South African": 80,
		Singaporean: 80,
		Malagasy: 80,
		Thai: 80,
		Egyptian: 80,
		"Cape Verdean": 80,
		Angolan: 14,
		Afghan: 14,
		Azerbaijani: 14,
		Belarusian: 14,
		Libyan: 14,
		Austrian: 14,
		Bahraini: 14,
		Armenian: 14,
		Burmese: 14,
		Cambodian: 14,
		Cameroonian: 14,
		"Central African": 14,
		Cypriot: 14,
		Czech: 14,
		"a Cook Islander": 14,
		Croatian: 14,
		Fijian: 14,
		Ethiopian: 14,
		Estonian: 14,
		Georgian: 14,
		Ghanan: 14,
		Greek: 14,
		Hungarian: 14,
		Iraqi: 14,
		Israeli: 14,
		Kazakh: 14,
		Kuwaiti: 14,
		Maldivian: 14,
		Malawian: 14,
		Liberian: 14,
		Lebanese: 14,
		Marshallese: 14,
		Mauritian: 14,
		Namibian: 14,
		Mozambican: 14,
		Micronesian: 14,
		"New Caledonian": 14,
		Pakistani: 14,
		Omani: 14,
		Romanian: 14,
		Sammarinese: 14,
		Qatari: 14,
		Senegalese: 14,
		Somali: 14,
		Sudanese: 14,
		Syrian: 14,
		Swiss: 14,
		Turkmen: 14,
		Ukrainian: 14,
		Yemeni: 14,
		Zairian: 5,
		Albanian: 5,
		Bosnian: 5,
		Beninese: 5,
		Burundian: 5,
		Bulgarian: 5,
		Chadian: 5,
		Comorian: 5,
		Emirati: 5,
		Equatoguinean: 5,
		Finnish: 5,
		"East Timorese": 5,
		Gabonese: 5,
		Djiboutian: 5,
		Guinean: 5,
		Eritrean: 5,
		Gambian: 5,
		Guamanian: 5,
		Kurdish: 5,
		Jordanian: 5,
		Kenyan: 5,
		Kyrgyz: 5,
		Lithuanian: 5,
		Macedonian: 5,
		Latvian: 5,
		Malian: 5,
		Mosotho: 5,
		Motswana: 5,
		Moldovan: 5,
		Mongolian: 5,
		Mauritanian: 5,
		Nepalese: 5,
		Palestinian: 5,
		Polish: 5,
		Saudi: 5,
		"South Sudanese": 5,
		Uzbek: 5,
		"Sierra Leonean": 5,
		Seychellois: 5,
		Tajik: 5,
		Serbian: 5,
		Tongan: 5,
		Ugandan: 5,
		Zimbabwean: 5,
		Tuvaluan: 5,
		Togolese: 5,
		Luxembourgian: 5,
		Tibetan: 5,
		Zambian: 5,
		Tanzanian: 5,
		Kosovan: 3,
		Slovak: 3,
		Swazi: 3,
		Laotian: 3,
		Rwandan: 3,
		"Bissau-Guinean": 3,
		Burkinabé: 2,
		Niuean: 2,
		Vatican: 2,
		Slovene: 2,
		Maltese: 2,
		"I-Kiribati": 2,
		Monégasque: 2,
		"Ni-Vanuatu": 2,
		Andorran: 2,
		Bhutanese: 2,
		"a Liechtensteiner": 2,
		Montenegrin: 2,
		Nauruan: 2,
		Palauan: 2,
		"São Toméan": 2,
		Sahrawi: 2
	}],

]);
